/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.LinuxParallel;
import com.sun.comm.LinuxSerial;
import java.io.IOException;
import javax.comm.CommDriver;
import javax.comm.CommPort;

public class LinuxDriver
implements CommDriver {
    private static boolean debug = false;
    private boolean driverInitialized = false;

    public void initialize() {
        if (!this.driverInitialized) {
            try {
                System.loadLibrary("LinuxSerialParallel");
            }
            catch (SecurityException ex1) {
                System.err.println("Security Exception LinuxSerialParallel: " + ex1);
            }
            catch (UnsatisfiedLinkError ex2) {
                System.err.println("Error loading LinuxSerialParallel: " + ex2);
            }
            this.driverInitialized = true;
        }
    }

    public CommPort getCommPort(String portName, int portType) {
        CommPort port = null;
        try {
            switch (portType) {
                case 1: {
                    port = new LinuxSerial(portName);
                    break;
                }
                case 2: {
                    port = new LinuxParallel(portName);
                }
            }
        }
        catch (IOException e) {
            System.err.println("\n");
            throw new RuntimeException("\n" + e.getMessage());
        }
        return port;
    }
}

